// Autor: Tonko Sabolcec

#include <cstdio>
#include <algorithm>
#include <queue>
using namespace std;

typedef long long ll;

const ll INF = 1LL << 60;
const int MAXN = 100100;

enum Actions {WORK, ADD, REMOVE, STOP};

struct Node {
  pair<ll, int> tm;
  int cnt;
  friend Node operator+(const Node &a, const Node &b) {
    return {min(a.tm, b.tm), a.cnt + b.cnt};
  }
};

const int off = 1 << 17;
const Node null = {{INF, -1}, 0};
Node data[2*off];

void init() {
  for (int i = 0; i < 2*off; ++i)
    data[i] = null;
}

void update(int p, Node v) {
  p += off;
  data[p] = v;
  for (p /= 2; p > 0; p /= 2)
    data[p] = data[2*p] + data[2*p+1];
}

Node query(int from, int to, int nd = 1, int lo = 0, int hi = off) {
  if (lo >= from && hi <= to) return data[nd];
  if (lo >= to || hi <= from) return null;
  int mid = (lo + hi) / 2;
  return query(from, to, 2*nd, lo, mid)
       + query(from, to, 2*nd+1, mid, hi);
}

int n;
int t[MAXN];
int d[MAXN];

ll total_time;
ll cycles;
int threads;
int current;
int last;

void work(ll tm) {
  total_time += tm;
  if (!threads) return;
  cycles += tm / threads;
  current += tm % threads;
  if (current >= threads) {
    current -= threads;
    cycles++;
  }
}

void remove_thread(int i) {
  threads--;
  current--;
  if (current < 0) current = 0;
  update(i, null);
}

void add_thread(int i) {
  threads++;
  update(i, {{cycles + t[i] - 1, i}, 1});
}

pair<ll, int> next_out() {
  auto nd = query(0, off);
  if (nd.tm.first == INF) return {INF, 0};
  int idx = query(0, nd.tm.second).cnt;
  ll dist = (ll)(nd.tm.first - cycles) * threads + (idx - current) + 1;
  return {dist, nd.tm.second};
}

pair<ll, int> next_in() {
  if (last == n) return {INF, 0};
  return {d[last] - total_time, last};
}

pair<int, ll> next_action() {
  static pair<int, ll> waiting = {-1, -1};
  if (waiting.first != -1) {
    auto ret = waiting;
    waiting = {-1, -1};
    return ret;
  }
  auto a1 = next_out();
  auto a2 = next_in();
  if (a1.first == INF && a2.first == INF) return {STOP, 0};
  if (a1.first <= a2.first) {
    waiting = {REMOVE, (ll)a1.second};
    return {WORK, a1.first};
  }
  last++;
  waiting = {ADD, (ll)a2.second};
  return {WORK, a2.first};
}

int main(void) {
  scanf("%d", &n);
  for (int i = 0; i < n; ++i)
    scanf("%d%d", &d[i], &t[i]);

  init();

  static ll ans[MAXN];

  for (auto a = next_action(); a.first != STOP; a = next_action()) {
    switch (a.first) {
      case WORK:
        work(a.second);
        break;
      case ADD:
        add_thread((int)a.second);
        break;
      case REMOVE:
        ans[a.second] = total_time - 1;
        remove_thread((int)a.second);
        break;
    }
  }

  for (int i = 0; i < n; ++i)
    printf("%lld\n", ans[i]);

  return 0;
}
